/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.attribute;

import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IModifierOp;
import dev.toma.gunsrpg.api.common.attribute.IModifierSerializer;
import dev.toma.gunsrpg.api.common.attribute.ITickableModifier;
import dev.toma.gunsrpg.common.attribute.serialization.ModifierSerialization;
import java.util.UUID;

public class ExpiringModifier
implements IAttributeModifier,
ITickableModifier {
    private final UUID uuid;
    private final IModifierOp op;
    private final double value;
    private final int initialTime;
    private int time;

    public ExpiringModifier(String uuid, IModifierOp op, double value, int expiresIn) {
        this(UUID.fromString(uuid), op, value, expiresIn);
    }

    public ExpiringModifier(UUID uuid, IModifierOp op, double value, int expiresIn) {
        this.uuid = uuid;
        this.op = op;
        this.value = value;
        this.initialTime = expiresIn;
        this.time = expiresIn;
    }

    @Override
    public UUID getUid() {
        return this.uuid;
    }

    @Override
    public IModifierOp getOperation() {
        return this.op;
    }

    @Override
    public double getModifierValue() {
        return this.value;
    }

    @Override
    public IModifierSerializer<?> getSerializer() {
        return ModifierSerialization.EXPIRING;
    }

    @Override
    public IAttributeModifier instance() {
        return new ExpiringModifier(this.uuid, this.op, this.value, this.initialTime);
    }

    @Override
    public void tick() {
        --this.time;
    }

    @Override
    public boolean shouldRemove() {
        return this.time <= 0;
    }

    public int getTimeLeft() {
        return this.time;
    }

    public int getInitialTime() {
        return this.initialTime;
    }

    public void setTimeLeft(int time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpiringModifier modifier = (ExpiringModifier)o;
        return this.uuid.equals(modifier.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return "Type: expiring_modifier, UUID: " + this.uuid + ", value: " + this.value + ", op: " + this.op + ", ticksRemaining: " + this.time;
    }
}

